<?php
# URL Template
function theme_url()
{
    echo get_template_directory_uri();
}
function get_theme_url()
{
    return get_template_directory_uri();
}
# URL Blog
function blog_url()
{
    echo bloginfo('url');
}
function get_blog_url()
{
    return bloginfo('url');
}

function vince_check_active_menu($menu_item)
{
    $actual_link = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    if ($actual_link == $menu_item->url) {
        return 'is-active';
    }
    return '';
}

function vince_check_active_menu_local($url)
{
    $actual_link = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    if ($actual_link == $url) {
        return 'is-active';
    }
    return '';
}

function telCorrect($tel)
{
    $tel = trim($tel);
    $tel = str_replace('(', '', $tel);
    $tel = str_replace(')', '', $tel);
    $tel = str_replace('-', '', $tel);
    $tel = str_replace(' ', '', $tel);
    $tel = str_replace('.', '', $tel);
    return $tel;
}
function imagenesAlt($image)
{
    if ($image["alt"]) {
        return $image["alt"];
    } else if ($image["description"]) {
        return $image["description"];
    } else {
        return $image["title"];
    }
}
function get_active_menu_static($url)
{
    $actual_link = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    if ($actual_link == $url) {
        return 'is-active';
    }
    return '';
}

# Enqueue Frontend Styles
add_action('wp_enqueue_scripts', 'load_css_frames');
function load_css_frames()
{
    wp_enqueue_style('swiper-css', get_template_directory_uri() . "/css/swiper.min.css", array(), '', '');
    wp_enqueue_style('style', get_template_directory_uri() . "/css/main.css", array(), '', '');
}
# Enqueue Frontend Styles
add_action('wp_enqueue_scripts', 'load_scripts_frames');
function load_scripts_frames()
{
    wp_enqueue_script('additional-methods', get_template_directory_uri() . '/assets/js/additional-methods.js', array(), '', 'jquery');
    wp_enqueue_script('swiper', get_template_directory_uri() . '/assets/js/swiper.min.js', array(), '', 'jquery');
    wp_enqueue_script('gsap', get_template_directory_uri() . '/assets/js/gsap.min.js', '', 'jquery');
    wp_enqueue_script('gsap-scroll', get_template_directory_uri() . '/assets/js/ScrollTrigger.min.js', '', 'jquery');
    wp_enqueue_script('main', get_template_directory_uri() . "/assets/js/main.js", array(), '', 'jquery');
    wp_localize_script('main', 'aj_ajax', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'aj_nonce' => wp_create_nonce('aj-nonce')
    ));
}

# Oculta Adminbar
show_admin_bar(false);

function remove_editor()
{
    remove_post_type_support('page', 'editor');
}
add_action('admin_init', 'remove_editor');

# Guarda y sincroniza ACF FILES
function my_acf_json_save_point($path)
{
    $path = get_stylesheet_directory() . '/assets/inc/acfCustom/';
    return $path;
}
add_filter('acf/settings/save_json', 'my_acf_json_save_point');

function my_acf_json_load_point($paths)
{
    unset($paths[0]);
    $paths[] = get_stylesheet_directory() . '/assets/inc/acfCustom/';
    return $paths;
}
add_filter('acf/settings/load_json', 'my_acf_json_load_point');

#SMK
include 'assets/inc/smk.php';
?>